<?php
echo "Iniciando diagnóstico...<br>";

// 1. Mostrar errores de PHP
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 2. Definir rutas base
define('ROOT_PATH', dirname(__FILE__));
define('CONFIG_PATH', ROOT_PATH . '/config');
define('LIB_PATH', ROOT_PATH . '/lib');

echo "Rutas definidas...<br>";

// 3. Intentar incluir archivos clave
try {
    require_once CONFIG_PATH . '/configuracion.php';
    echo "✅ <b>configuracion.php</b> cargado.<br>";
    
    require_once CONFIG_PATH . '/conexion.php';
    echo "✅ <b>conexion.php</b> cargado.<br>";
    
    require_once LIB_PATH . '/funciones_comunes.php';
    echo "✅ <b>funciones_comunes.php</b> cargado.<br>";

} catch (Exception $e) {
    echo "❌ <b>ERROR FATAL AL INCLUIR ARCHIVOS:</b> " . $e->getMessage() . "<br>";
    exit;
}

// 4. Verificar si las funciones existen
if (function_exists('obtener_usuario_actual')) {
    echo "✅ Función <b>obtener_usuario_actual()</b> EXISTE.<br>";
} else {
    echo "❌ <b>ERROR CRÍTICO:</b> La función <b>obtener_usuario_actual()</b> NO EXISTE. El problema está en `funciones_comunes.php`.<br>";
}

if (function_exists('obtener_empresa_actual')) {
    echo "✅ Función <b>obtener_empresa_actual()</b> EXISTE.<br>";
} else {
    echo "❌ <b>ERROR CRÍTICO:</b> La función <b>obtener_empresa_actual()</b> NO EXISTE. El problema está en `funciones_comunes.php`.<br>";
}

echo "<br>Diagnóstico finalizado.";

?>
