<?php
/**
 * Script de Seguridad para el Portal de Clientes
 *
 * Este script verifica si un cliente ha iniciado sesión.
 * Si no lo ha hecho, lo redirige a la página de login.
 * Debe ser incluido al principio de cada página protegida del portal.
 */

// Inicia la sesión si aún no está activa para poder leer las variables de sesión.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Comprueba si la variable de sesión 'cliente_logged_in' existe y si es verdadera.
if (!isset($_SESSION['cliente_logged_in']) || $_SESSION['cliente_logged_in'] !== true) {
    
    // Si el cliente no ha iniciado sesión:
    // 1. Prepara un mensaje de error para mostrar en la página de login.
    $_SESSION['mensaje_login'] = ['texto' => 'Debe iniciar sesión para acceder a esta página.', 'tipo' => 'warning'];
    
    // 2. Redirige al usuario a la página de login.
    // La ruta es relativa al directorio raíz del sitio.
    header('Location: /portal/login.php'); 
    
    // 3. Detiene la ejecución del script actual para asegurar la redirección.
    exit;
}

// Si el script llega hasta aquí, significa que el cliente sí ha iniciado sesión
// y la página que incluye este archivo puede continuar cargándose.
?>
