<?php
// 1. Seguridad: Asegurar que el cliente está logueado.
require_once __DIR__ . '/../private/controllers/portal/portal_seguridad.php';
require_once __DIR__ . '/../../conexion.php';

// 2. Validar el ID del caso desde la URL.
$caso_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$caso_id) {
    die("ID de caso no válido.");
}

// 3. Obtener el ID del cliente desde la sesión.
$cliente_id = $_SESSION['cliente_id'];

// 4. Obtener los datos del caso, ASEGURANDO que pertenece al cliente actual.
$stmt = $conexion->prepare("SELECT * FROM casos WHERE id = ? AND id_cliente = ?");
$stmt->bind_param("ii", $caso_id, $cliente_id);
$stmt->execute();
$resultado_caso = $stmt->get_result();
$caso = $resultado_caso->fetch_assoc();
$stmt->close();

// Si no se encuentra el caso, es porque no existe o no pertenece a este cliente.
if (!$caso) {
    die("Acceso denegado o caso no encontrado.");
}

// 5. Obtener el historial de respuestas para este caso.
$respuestas = [];
$stmt = $conexion->prepare("SELECT * FROM respuestas WHERE id_caso = ? ORDER BY fecha_creacion ASC");
$stmt->bind_param("i", $caso_id);
$stmt->execute();
$resultado_respuestas = $stmt->get_result();
while ($fila = $resultado_respuestas->fetch_assoc()) {
    $respuestas[] = $fila;
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Detalle del Caso #<?php echo $caso['id']; ?></title>
    <link rel="stylesheet" href="../assets/css/main.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php">Portal Clientes SSR</a>
            <a href="logout.php" class="btn btn-outline-danger">Cerrar Sesión</a>
        </div>
    </nav>

    <div class="container mt-4">
        <a href="dashboard.php" class="btn btn-secondary mb-3">&larr; Volver a Mis Casos</a>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h3>Detalle del Caso #<?php echo htmlspecialchars($caso['id']); ?></h3>
                <span class="badge bg-primary fs-6"><?php echo htmlspecialchars($caso['estado']); ?></span>
            </div>
            <div class="card-body">
                <p><strong>Fecha de Creación:</strong> <?php echo date('d-m-Y H:i', strtotime($caso['fecha_creacion'])); ?></p>
                <p><strong>Tipo:</strong> <?php echo htmlspecialchars(ucfirst($caso['tipificacion'])); ?></p>
                <hr>
                <h5>Descripción Original:</h5>
                <p><?php echo nl2br(htmlspecialchars($caso['descripcion'])); ?></p>

                <?php if ($caso['ruta_adjunto']): ?>
                    <p><strong>Archivo Adjunto:</strong> 
                        <a href="descargar_adjunto.php?id=<?php echo $caso['id']; ?>" class="btn btn-sm btn-success">Descargar PDF</a>
                    </p>
                <?php endif; ?>
            </div>
        </div>

        <h4 class="mt-4">Historial de Respuestas</h4>
        <div class="list-group">
            <?php if (empty($respuestas)): ?>
                <div class="list-group-item">
                    <p class="mb-1">Aún no hay respuestas para este caso.</p>
                </div>
            <?php else: ?>
                <?php foreach ($respuestas as $respuesta): ?>
                    <div class="list-group-item list-group-item-action flex-column align-items-start">
                        <div class="d-flex w-100 justify-content-between">
                            <h5 class="mb-1">Respuesta del Operador</h5>
                            <small><?php echo date('d-m-Y H:i', strtotime($respuesta['fecha_creacion'])); ?></small>
                        </div>
                        <p class="mb-1"><?php echo nl2br(htmlspecialchars($respuesta['mensaje'])); ?></p>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
