<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portal del Cliente - Crear Cuenta</title>
    
    <!-- Bootstrap y nuestros estilos personalizados -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/portal_styles.css">
</head>
<body>

    <div class="portal-container">
        <div class="portal-card">
            <div class="portal-header">
                <h2>Crear una Cuenta</h2>
                <p>Regístrese para acceder al portal de clientes.</p>
            </div>

            <div id="mensaje-registro" class="mb-3"></div>

            <form id="register-form" method="POST" action="">
                <div class="mb-3">
                    <label for="rut" class="form-label">RUT del Cliente</label>
                    <input type="text" class="form-control" id="rut" name="rut" placeholder="Sin puntos y con guión (Ej: 12345678-9)" required>
                </div>
                <div class="mb-3">
                    <label for="email" class="form-label">Correo Electrónico</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Crear Contraseña</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>
                <div class="mb-4">
                    <label for="password_confirm" class="form-label">Confirmar Contraseña</label>
                    <input type="password" class="form-control" id="password_confirm" name="password_confirm" required>
                </div>
                <div class="d-grid">
                    <button type="submit" id="submit-btn" class="btn btn-portal-primary">Crear Cuenta</button>
                </div>
            </form>

            <div class="portal-links">
                <span>¿Ya tienes una cuenta? </span><a href="login.php">Inicia sesión aquí</a>
            </div>
        </div>
    </div>

    <script src="../assets/js/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#register-form').on('submit', function(e) {
                e.preventDefault();
                $('#submit-btn').prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Creando cuenta...');

                $.ajax({
                    type: 'POST',
                    url: '../private/controllers/portal/auth_controller.php?action=register',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.status === 'success') {
                            $('#mensaje-registro').html('<div class="alert alert-success">' + response.message + ' Redirigiendo al login...</div>');
                            setTimeout(function() { window.location.href = 'login.php'; }, 3000);
                        } else {
                            $('#mensaje-registro').html('<div class="alert alert-danger">' + response.message + '</div>');
                            $('#submit-btn').prop('disabled', false).text('Crear Cuenta');
                        }
                    },
                    error: function() {
                        $('#mensaje-registro').html('<div class="alert alert-danger">Error de comunicación.</div>');
                        $('#submit-btn').prop('disabled', false).text('Crear Cuenta');
                    }
                });
            });
        });
    </script>
</body>
</html>
