<?php
// Incluir el archivo de configuración. La ruta es relativa: subir un nivel, entrar a /config.
require_once __DIR__ . '/../config/configuracion.php';

// Activar o desactivar los errores según el modo de depuración.
if (defined('DEBUG_MODE') && DEBUG_MODE === true) {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
} else {
    ini_set('display_errors', 0);
    error_reporting(0);
}

// Usar la constante APP_ROOT para incluir los demás archivos de forma segura y absoluta.
require_once APP_ROOT . '/private/controllers/portal/portal_seguridad.php';
require_once APP_ROOT . '/conexion.php';

// --- Lógica de la página ---
$cliente_id = $_SESSION['cliente_id'];
$casos = [];
$stmt = $conexion->prepare("SELECT id, fecha_creacion, tipificacion, estado FROM casos WHERE id_cliente = ? ORDER BY fecha_creacion DESC");
$stmt->bind_param("i", $cliente_id);
$stmt->execute();
$resultado = $stmt->get_result();
while ($fila = $resultado->fetch_assoc()) {
    $casos[] = $fila;
}
$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mi Portal - <?php echo NOMBRE_SISTEMA; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/portal_styles.css">
</head>
<body class="dashboard-body">

    <nav class="navbar navbar-expand-lg portal-navbar">
        <div class="container">
            <a class="navbar-brand" href="dashboard.php"><?php echo NOMBRE_SISTEMA; ?></a>
            <div class="d-flex align-items-center">
                <span class="navbar-text me-3">
                    Hola, <strong><?php echo htmlspecialchars($_SESSION['cliente_nombre']); ?></strong>
                </span>
                <a href="logout.php" class="btn btn-outline-secondary btn-sm">Cerrar Sesión</a>
            </div>
        </div>
    </nav>

    <div class="container dashboard-container">
        <?php 
        $mensaje = $_SESSION['mensaje'] ?? null;
        if ($mensaje) {
            echo '<div class="alert alert-'.$mensaje['tipo'].' alert-dismissible fade show" role="alert">'.htmlspecialchars($mensaje['texto']).'<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>';
            unset($_SESSION['mensaje']);
        }
        ?>

        <div class="card cases-card">
            <div class="card-header cases-card-header d-flex justify-content-between align-items-center">
                <h3>Mis Casos</h3>
                <a href="crear_caso.php" class="btn btn-primary">+ Crear Nuevo Caso</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th scope="col" class="ps-4">N° Caso</th>
                                <th scope="col">Fecha</th>
                                <th scope="col">Tipo</th>
                                <th scope="col">Estado</th>
                                <th scope="col" class="text-end pe-4">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($casos)): ?>
                                <tr>
                                    <td colspan="5" class="text-center p-4 text-muted">No tiene casos registrados. ¡Cree su primer caso!</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($casos as $caso): 
                                    $estado_clase = 'bg-secondary';
                                    if ($caso['estado'] === 'NUEVO') $estado_clase = 'bg-status-nuevo';
                                    if ($caso['estado'] === 'EN PROCESO') $estado_clase = 'bg-status-en-proceso';
                                    if ($caso['estado'] === 'CERRADO') $estado_clase = 'bg-status-cerrado';
                                ?>
                                    <tr>
                                        <td class="ps-4"><strong>#<?php echo htmlspecialchars($caso['id']); ?></strong></td>
                                        <td><?php echo date('d/m/Y', strtotime($caso['fecha_creacion'])); ?></td>
                                        <td><?php echo htmlspecialchars(ucfirst($caso['tipificacion'])); ?></td>
                                        <td><span class="badge <?php echo $estado_clase; ?>"><?php echo htmlspecialchars($caso['estado']); ?></span></td>
                                        <td class="text-end pe-4">
                                            <a href="ver_caso.php?id=<?php echo $caso['id']; ?>" class="btn btn-sm btn-outline-primary">Ver Detalle</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
