<?php
// Módulo: Crear Cliente
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

$usuario = obtener_usuario_actual($conn);
$empresa = obtener_empresa_actual($conn);
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = sanitizar_html($_POST['nombre'] ?? '');
    $rut = sanitizar_html($_POST['rut'] ?? '');
    $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);
    $telefono = sanitizar_html($_POST['telefono'] ?? '');
    
    if ($nombre && $rut && $email) {
        // Verificar si el RUT o Email ya existen
        $sql_check = "SELECT id FROM clientes WHERE (rut = ? OR email = ?) AND empresa_id = ?";
        $stmt_check = $conn->prepare($sql_check);
        $stmt_check->bind_param("ssi", $rut, $email, $empresa['id']);
        $stmt_check->execute();
        $result_check = $stmt_check->get_result();
        
        if ($result_check->num_rows > 0) {
            $error = "El RUT o el Email ya se encuentran registrados en el sistema.";
        } else {
            // Insertar nuevo cliente
            $sql = "INSERT INTO clientes (empresa_id, nombre, rut, email, telefono, activo, fecha_creacion) 
                    VALUES (?, ?, ?, ?, ?, 1, NOW())";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("issss", $empresa['id'], $nombre, $rut, $email, $telefono);

            if ($stmt->execute()) {
                header('Location: ' . BASE_URL . 'clientes');
                exit;
            } else {
                $error = "Error al crear el cliente. Por favor, intente de nuevo.";
            }
            $stmt->close();
        }
        $stmt_check->close();
    } else {
        $error = "Por favor, complete todos los campos obligatorios (*).";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Crear Nuevo Cliente - Portal Reclamos SSR</title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/estilos.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-content">
            <a href="<?= BASE_URL ?>dashboard" class="navbar-brand">Portal Reclamos SSR</a>
             <div class="navbar-menu">
                <a href="<?= BASE_URL ?>casos">Casos</a>
                <a href="<?= BASE_URL ?>clientes" class="active">Clientes</a>
            </div>
        </div>
    </nav>
    
    <div class="container">
        <div class="header">
            <h1>Crear Nuevo Cliente</h1>
            <a href="<?= BASE_URL ?>clientes" class="btn btn-secondary">← Volver</a>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <div class="card">
            <form method="POST">
                <div class="form-group">
                    <label>Nombre Completo *</label>
                    <input type="text" name="nombre" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>RUT *</label>
                    <input type="text" name="rut" class="form-control" required placeholder="Ej: 12345678-9">
                </div>
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Teléfono</label>
                    <input type="text" name="telefono" class="form-control">
                </div>
                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Guardar Cliente</button>
                    <a href="<?= BASE_URL ?>clientes" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
