<?php
// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

// Obtener usuario y empresa
$usuario = obtener_usuario_actual($conn);
$empresa = obtener_empresa_actual($conn);


// Obtener ID del caso
$url_parts = explode('/', trim($_GET['url'] ?? '', '/'));
$caso_id = isset($url_parts[1]) ? intval($url_parts[1]) : 0;

if (!$caso_id) {
    header('Location: ' . BASE_URL . 'casos');
    exit;
}

// Obtener caso
$sql = "SELECT c.*, cl.nombre as cliente_nombre 
        FROM casos c 
        JOIN clientes cl ON c.cliente_id = cl.id 
        WHERE c.id = ? AND c.empresa_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $caso_id, $empresa['id']);
$stmt->execute();
$caso = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$caso) {
    header('Location: ' . BASE_URL . 'casos');
    exit;
}

$mensaje = '';
$error = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $respuesta = $_POST['respuesta'] ?? '';
    $enviar_cliente = isset($_POST['enviar_cliente']) ? 1 : 0;

    if ($respuesta) {
        // Insertar respuesta
        $sql_resp = "INSERT INTO respuestas (caso_id, usuario_id, contenido_respuesta, estado, enviado_cliente, fecha_respuesta) 
                     VALUES (?, ?, ?, 'enviado', ?, NOW())";
        $stmt = $conn->prepare($sql_resp);
        $stmt->bind_param("iisi", $caso_id, $usuario['id'], $respuesta, $enviar_cliente);

        if ($stmt->execute()) {
            $stmt->close();

            // Actualizar estado del caso
            $nuevo_estado = 'respondido';
            $sql_update = "UPDATE casos SET estado = ?, fecha_actualizacion = NOW() WHERE id = ?";
            $stmt = $conn->prepare($sql_update);
            $stmt->bind_param("si", $nuevo_estado, $caso_id);
            $stmt->execute();
            $stmt->close();

            header('Location: ' . BASE_URL . 'casos/' . $caso_id);
            exit;
        } else {
            $error = "Error al guardar la respuesta";
        }
        $stmt->close();
    } else {
        $error = "La respuesta no puede estar vacía";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Responder Caso <?= $caso['numero_caso'] ?></title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/estilos.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-content">
            <a href="<?= BASE_URL ?>dashboard" class="navbar-brand">Portal Reclamos SSR</a>
            <div class="navbar-menu">
                <a href="<?= BASE_URL ?>casos">Casos</a>
                <div class="navbar-user">
                    <div class="user-avatar"><?= strtoupper(substr($usuario['nombre'], 0, 2)) ?></div>
                    <a href="<?= BASE_URL ?>logout" class="btn btn-secondary btn-sm">Salir</a>
                </div>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="header">
            <h1>Responder Caso: <?= $caso['numero_caso'] ?></h1>
            <a href="<?= BASE_URL ?>casos/<?= $caso['id'] ?>" class="btn btn-secondary">← Volver</a>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <!-- Información del Caso -->
            <div class="card">
                <h3>Información del Caso</h3>
                <p><strong>Cliente:</strong> <?= $caso['cliente_nombre'] ?></p>
                <p><strong>Tipo:</strong> <?= ucfirst($caso['tipo_caso']) ?></p>
                <p><strong>Estado:</strong> <span class="badge badge-info"><?= ucfirst($caso['estado']) ?></span></p>
                <hr>
                <h4>Asunto</h4>
                <p><?= $caso['asunto'] ?></p>
                <h4>Descripción</h4>
                <div style="background: #f9fafb; padding: 15px; border-radius: 8px;">
                    <?= nl2br($caso['descripcion']) ?>
                </div>
            </div>

            <!-- Formulario de Respuesta -->
            <div class="card">
                <h3>Nueva Respuesta</h3>
                <form method="POST">
                    <div class="form-group">
                        <label>Respuesta *</label>
                        <textarea name="respuesta" required class="form-control" rows="12" placeholder="Escriba su respuesta al cliente..."></textarea>
                    </div>

                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 10px;">
                            <input type="checkbox" name="enviar_cliente" checked>
                            <span>Enviar notificación al cliente</span>
                        </label>
                    </div>

                    <div style="display: flex; gap: 10px;">
                        <button type="submit" class="btn btn-success">Guardar Respuesta</button>
                        <a href="<?= BASE_URL ?>casos/<?= $caso['id'] ?>" class="btn btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
