<?php
// /modulos/casos/listar_casos.php

// 1. Definir el título de la página
$page_title = 'Gestión de Casos';

// 2. Incluir el header, que se encarga de la seguridad y la conexión.
require_once dirname(__DIR__, 2) . '/templates/header.php';

// La variable $conn ya está disponible aquí gracias al header.

// --- Lógica para obtener los casos de la base de datos ---
$sql_casos = "SELECT c.id, c.descripcion as asunto, cl.nombre as cliente_nombre, c.estado, c.prioridad, c.fecha_creacion 
              FROM casos c 
              JOIN clientes cl ON c.id_cliente = cl.id 
              ORDER BY c.fecha_creacion DESC";
$resultado_casos = $conn->query($sql_casos);

?>

<!-- HTML de la página -->
<div class="header flex-between">
    <h1><?php echo $page_title; ?></h1>
    <!-- Corregimos la ruta para crear un nuevo caso usando la constante BASE_URL -->
    <a href="<?php echo BASE_URL; ?>casos/crear" class="btn btn-primary">Crear Nuevo Caso</a>
</div>

<div class="card p-20">
    <!-- Formulario de Búsqueda -->
    <form method="GET" action="<?php echo BASE_URL; ?>casos" class="search-form mb-20">
        <input type="text" name="q" placeholder="Buscar..." value="">
        <button type="submit" class="btn">Buscar</button>
    </form>

    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>N° Caso</th>
                    <th>Asunto</th>
                    <th>Cliente</th>
                    <th>Estado</th>
                    <th>Prioridad</th>
                    <th>Fecha Creación</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($resultado_casos && $resultado_casos->num_rows > 0): ?>
                    <?php while($caso = $resultado_casos->fetch_assoc()): ?>
                        <tr>
                            <td>#<?php echo sanitizar_html($caso['id']); ?></td>
                            <td><?php echo sanitizar_html(substr($caso['asunto'], 0, 50)) . '...'; ?></td>
                            <td><?php echo sanitizar_html($caso['cliente_nombre']); ?></td>
                            <td><span class="badge"><?php echo sanitizar_html($caso['estado']); ?></span></td>
                            <td><span class="badge"><?php echo sanitizar_html($caso['prioridad'] ?? 'Normal'); ?></span></td>
                            <td><?php echo formato_fecha($caso['fecha_creacion']); ?></td>
                            <td>
                                <!-- Corregimos la ruta para ver el detalle -->
                                <a href="<?php echo BASE_URL; ?>casos/detalle/<?php echo $caso['id']; ?>" class="btn btn-sm btn-outline-primary">Ver</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center">No se encontraron casos que coincidan con su búsqueda o no hay casos registrados.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php
// 3. Incluir el footer para cerrar la página
require_once dirname(__DIR__, 2) . '/templates/footer.php';
?>
