<?php
// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

// Obtener usuario y empresa
$usuario = obtener_usuario_actual($conn);
$empresa = obtener_empresa_actual($conn);
;

// Obtener ID del caso de la URL
$url_parts = explode('/', trim($_GET['url'] ?? '', '/'));
$caso_id = isset($url_parts[1]) ? intval($url_parts[1]) : 0;

if (!$caso_id) {
    header('Location: ' . BASE_URL . 'casos');
    exit;
}

// Obtener caso con información del cliente
$sql = "SELECT c.*, cl.nombre as cliente_nombre, cl.rut as cliente_rut, cl.email as cliente_email,
               u.nombre as creador_nombre
        FROM casos c 
        JOIN clientes cl ON c.cliente_id = cl.id 
        LEFT JOIN usuarios u ON c.usuario_creador_id = u.id
        WHERE c.id = ? AND c.empresa_id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $caso_id, $empresa['id']);
$stmt->execute();
$caso = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$caso) {
    header('Location: ' . BASE_URL . 'casos');
    exit;
}

// Obtener respuestas del caso
$sql_resp = "SELECT r.*, u.nombre as usuario_nombre 
             FROM respuestas r
             LEFT JOIN usuarios u ON r.usuario_id = u.id
             WHERE r.caso_id = ?
             ORDER BY r.fecha_respuesta DESC";
$stmt = $conn->prepare($sql_resp);
$stmt->bind_param("i", $caso_id);
$stmt->execute();
$respuestas = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $caso['numero_caso'] ?> - Portal Reclamos SSR</title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/estilos.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-content">
            <a href="<?= BASE_URL ?>dashboard" class="navbar-brand">Portal Reclamos SSR</a>
            <div class="navbar-menu">
                <a href="<?= BASE_URL ?>casos">Casos</a>
                <div class="navbar-user">
                    <div class="user-avatar"><?= strtoupper(substr($usuario['nombre'], 0, 2)) ?></div>
                    <a href="<?= BASE_URL ?>logout" class="btn btn-secondary btn-sm">Salir</a>
                </div>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="header">
            <div>
                <h1><?= $caso['numero_caso'] ?></h1>
                <p style="color: #6b7280;">Cliente: <?= $caso['cliente_nombre'] ?></p>
            </div>
            <div style="display: flex; gap: 10px;">
                <a href="<?= BASE_URL ?>casos/<?= $caso['id'] ?>/responder" class="btn btn-success">Responder</a>
                <a href="<?= BASE_URL ?>casos" class="btn btn-secondary">← Volver</a>
            </div>
        </div>

        <!-- Información del Caso -->
        <div class="card">
            <h3>Información del Caso</h3>
            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 20px; margin-top: 20px;">
                <div>
                    <p><strong>Tipo:</strong> <?= ucfirst($caso['tipo_caso']) ?></p>
                    <p><strong>Estado:</strong> <span class="badge badge-info"><?= ucfirst($caso['estado']) ?></span></p>
                    <p><strong>Prioridad:</strong> <span class="badge badge-<?= $caso['prioridad'] === 'alta' ? 'danger' : 'warning' ?>"><?= ucfirst($caso['prioridad']) ?></span></p>
                </div>
                <div>
                    <p><strong>Fecha Creación:</strong> <?= date('d/m/Y H:i', strtotime($caso['fecha_creacion'])) ?></p>
                    <p><strong>Creado por:</strong> <?= $caso['creador_nombre'] ?? 'Sistema' ?></p>
                    <p><strong>Cliente Email:</strong> <?= $caso['cliente_email'] ?></p>
                </div>
            </div>

            <hr style="margin: 20px 0;">

            <h4>Asunto</h4>
            <p><?= $caso['asunto'] ?></p>

            <h4>Descripción</h4>
            <div style="background: #f9fafb; padding: 15px; border-radius: 8px; margin-top: 10px;">
                <?= nl2br($caso['descripcion']) ?>
            </div>
        </div>

        <!-- Respuestas -->
        <?php if (!empty($respuestas)): ?>
        <div class="card">
            <h3>Respuestas (<?= count($respuestas) ?>)</h3>
            <?php foreach ($respuestas as $resp): ?>
                <div style="border-left: 3px solid #38bdf8; padding-left: 15px; margin: 20px 0;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 10px;">
                        <strong><?= $resp['usuario_nombre'] ?? 'Usuario' ?></strong>
                        <span style="color: #6b7280; font-size: 14px;">
                            <?= date('d/m/Y H:i', strtotime($resp['fecha_respuesta'])) ?>
                        </span>
                    </div>
                    <p><?= nl2br($resp['contenido_respuesta']) ?></p>
                    <span class="badge badge-<?= $resp['estado'] === 'enviado' ? 'success' : 'warning' ?>">
                        <?= ucfirst($resp['estado']) ?>
                    </span>
                </div>
            <?php endforeach; ?>
        </div>
        <?php else: ?>
        <div class="card">
            <p style="text-align: center; color: #6b7280;">Sin respuestas aún. <a href="<?= BASE_URL ?>casos/<?= $caso['id'] ?>/responder">Agregar respuesta</a></p>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
