<?php
// Verificar autenticación
if (!isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'login');
    exit;
}

// Obtener usuario y empresa
$usuario = obtener_usuario_actual($conn);
$empresa = obtener_empresa_actual($conn);


if (!$usuario || !$empresa) {
    die("Error: Usuario o empresa no válidos");
}

$mensaje = '';
$error = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cliente_id = intval($_POST['cliente_id'] ?? 0);
    $tipo_caso = $_POST['tipo_caso'] ?? '';
    $prioridad = $_POST['prioridad'] ?? 'media';
    $asunto = $_POST['asunto'] ?? '';
    $descripcion = $_POST['descripcion'] ?? '';

    if ($cliente_id && $tipo_caso && $asunto && $descripcion) {
        // Generar número de caso
        $sql_count = "SELECT COUNT(*) as total FROM casos WHERE empresa_id = ?";
        $stmt = $conn->prepare($sql_count);
        $stmt->bind_param("i", $empresa['id']);
        $stmt->execute();
        $count = $stmt->get_result()->fetch_assoc()['total'];
        $stmt->close();

        $numero_caso = 'AGUA-REC-' . str_pad($count + 1, 5, '0', STR_PAD_LEFT);

        // Insertar caso
        $sql = "INSERT INTO casos (empresa_id, numero_caso, cliente_id, usuario_creador_id, tipo_caso, asunto, descripcion, estado, prioridad, fecha_creacion) 
                VALUES (?, ?, ?, ?, ?, ?, ?, 'nuevo', ?, NOW())";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("isiissss", $empresa['id'], $numero_caso, $cliente_id, $usuario['id'], $tipo_caso, $asunto, $descripcion, $prioridad);

        if ($stmt->execute()) {
            $caso_id = $conn->insert_id;
            $stmt->close();
            header('Location: ' . BASE_URL . 'casos/' . $caso_id);
            exit;
        } else {
            $error = "Error al crear el caso: " . $conn->error;
        }
        $stmt->close();
    } else {
        $error = "Por favor complete todos los campos obligatorios";
    }
}

// Obtener clientes activos
$sql = "SELECT * FROM clientes WHERE empresa_id = ? AND activo = 1 ORDER BY nombre";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $empresa['id']);
$stmt->execute();
$clientes = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Crear Caso - Portal Reclamos SSR</title>
    <link rel="stylesheet" href="<?= BASE_URL ?>assets/css/estilos.css">
</head>
<body>
    <nav class="navbar">
        <div class="navbar-content">
            <a href="<?= BASE_URL ?>dashboard" class="navbar-brand">Portal Reclamos SSR</a>
            <div class="navbar-menu">
                <a href="<?= BASE_URL ?>casos">Casos</a>
                <div class="navbar-user">
                    <div class="user-avatar"><?= strtoupper(substr($usuario['nombre'], 0, 2)) ?></div>
                    <a href="<?= BASE_URL ?>logout" class="btn btn-secondary btn-sm">Salir</a>
                </div>
            </div>
        </div>
    </nav>

    <div class="container">
        <div class="header">
            <h1>Crear Nuevo Caso</h1>
            <a href="<?= BASE_URL ?>casos" class="btn btn-secondary">← Volver</a>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= $error ?></div>
        <?php endif; ?>

        <div class="card">
            <form method="POST">
                <div class="form-group">
                    <label>Cliente *</label>
                    <select name="cliente_id" required class="form-control">
                        <option value="">-- Seleccionar Cliente --</option>
                        <?php foreach ($clientes as $c): ?>
                            <option value="<?= $c['id'] ?>"><?= $c['nombre'] ?> (<?= $c['rut'] ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label>Tipo de Caso *</label>
                    <select name="tipo_caso" required class="form-control">
                        <option value="">-- Seleccionar Tipo --</option>
                        <option value="reclamo">Reclamo</option>
                        <option value="consulta">Consulta</option>
                        <option value="sugerencia">Sugerencia</option>
                        <option value="felicitacion">Felicitación</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Prioridad *</label>
                    <select name="prioridad" required class="form-control">
                        <option value="baja">Baja</option>
                        <option value="media" selected>Media</option>
                        <option value="alta">Alta</option>
                        <option value="urgente">Urgente</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Asunto *</label>
                    <input type="text" name="asunto" required class="form-control" placeholder="Ej: Falta de suministro de agua">
                </div>

                <div class="form-group">
                    <label>Descripción *</label>
                    <textarea name="descripcion" required class="form-control" rows="6" placeholder="Describa detalladamente el caso..."></textarea>
                </div>

                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Crear Caso</button>
                    <a href="<?= BASE_URL ?>casos" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
