<?php
/**
 * ENRUTADOR PRINCIPAL DEL BACK-OFFICE (Versión Corregida)
 */

// 1. Cargar la configuración. Es lo ÚNICO que hace este archivo directamente.
// Define APP_ROOT y BASE_URL, que estarán disponibles para todos los demás scripts.
require_once __DIR__ . '/config/configuracion.php';


// 2. OBTENER LA RUTA SOLICITADA
$url = $_GET['url'] ?? '';
$url = trim($url, '/');
$url = filter_var($url, FILTER_SANITIZE_URL);
$partes = explode('/', $url);
$ruta_principal = $partes[0] !== '' ? $partes[0] : 'login';


// 3. DEFINIR LA RUTA DEL ARCHIVO DEL MÓDULO USANDO APP_ROOT
$ruta_modulo = '';

switch ($ruta_principal) {
    
    case 'login':
        $ruta_modulo = APP_ROOT . '/modulos/auth/login.php';
        break;
        
    case 'logout':
        $ruta_modulo = APP_ROOT . '/modulos/auth/logout.php';
        break;

    case 'dashboard':
        $ruta_modulo = APP_ROOT . '/modulos/dashboard.php';
        break;
        
    case 'casos':
        if (isset($partes[1]) && $partes[1] === 'crear') {
            $ruta_modulo = APP_ROOT . '/modulos/casos/crear_caso.php';
        } elseif (isset($partes[1]) && is_numeric($partes[1])) {
            $ruta_modulo = APP_ROOT . '/modulos/casos/ver_caso.php';
        } else {
            $ruta_modulo = APP_ROOT . '/modulos/casos/listar_casos.php';
        }
        break;

    case 'clientes':
        $ruta_modulo = APP_ROOT . '/modulos/clientes/listar_clientes.php';
        break;

    case 'reportes':
        $ruta_modulo = APP_ROOT . '/modulos/reportes/reportes.php';
        break;

    default:
        // Si la ruta no se reconoce, redirigimos a una página de error 404
        $ruta_modulo = APP_ROOT . '/modulos/errores/404.php';
        break;
}


// 4. CARGAR EL MÓDULO O MOSTRAR ERROR 404
if (file_exists($ruta_modulo)) {
    require $ruta_modulo;
} else {
    // Error crítico si el archivo del módulo definido no existe.
    http_response_code(404);
    echo "Error 404: El archivo del módulo no se encuentra en la ruta: " . $ruta_modulo;
    exit;
}
?>
