<?php
function sanitizar_html($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

function validar_email($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL);
}

function hash_contrasena($contrasena) {
    return password_hash($contrasena, PASSWORD_BCRYPT, ['cost' => 10]);
}

function verificar_contrasena($contrasena, $hash) {
    return password_verify($contrasena, $hash);
}

function generar_csrf_token() {
    if (!isset($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function verificar_csrf_token($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}
?>